"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EksAddonsFilter = exports.EksAddonsFilterSchema = void 0;
const v4_1 = require("zod/v4");
const regex_1 = require("../../../util/regex");
const v4_2 = require("../../../util/schema-utils/v4");
exports.EksAddonsFilterSchema = v4_1.z.object({
    addonName: v4_1.z.string().nonempty().regex((0, regex_1.regEx)('^[a-z0-9][a-z0-9-]*[a-z0-9]$')),
    kubernetesVersion: v4_1.z
        .string()
        .regex((0, regex_1.regEx)('^(?<major>\\d+)\\.(?<minor>\\d+)$'))
        .optional(),
    default: v4_1.z
        .union([v4_1.z.boolean(), v4_1.z.string().transform((value) => value === 'true')])
        .optional(),
    region: v4_1.z.string().optional(),
    profile: v4_1.z.string().optional(),
});
exports.EksAddonsFilter = v4_2.Json.pipe(exports.EksAddonsFilterSchema);
//# sourceMappingURL=schema.js.map