"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsEKSAddonDataSource = void 0;
const tslib_1 = require("tslib");
const client_eks_1 = require("@aws-sdk/client-eks");
const credential_providers_1 = require("@aws-sdk/credential-providers");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const array_1 = require("../../../util/array");
const decorator_1 = require("../../../util/cache/package/decorator");
const awsEksAddonVersioning = tslib_1.__importStar(require("../../versioning/aws-eks-addon"));
const datasource_1 = require("../datasource");
const schema_1 = require("./schema");
class AwsEKSAddonDataSource extends datasource_1.Datasource {
    static id = 'aws-eks-addon';
    defaultVersioning = awsEksAddonVersioning.id;
    caching = true;
    clients = {};
    constructor() {
        super(AwsEKSAddonDataSource.id);
    }
    async getReleases({ packageName: serializedFilter, }) {
        const res = schema_1.EksAddonsFilter.safeParse(serializedFilter);
        if (!res.success) {
            logger_1.logger.warn({ err: res.error, serializedFilter }, 'Error parsing eks-addons config.');
            return null;
        }
        const filter = res.data;
        const cmd = new client_eks_1.DescribeAddonVersionsCommand({
            kubernetesVersion: filter.kubernetesVersion,
            addonName: filter.addonName,
            maxResults: 1,
        });
        const response = await this.getClient(filter).send(cmd);
        const addons = (0, array_1.coerceArray)(response.addons);
        return {
            releases: addons
                .flatMap((addon) => {
                return addon.addonVersions;
            })
                .filter(is_1.default.truthy)
                .map((versionInfo) => ({
                version: versionInfo.addonVersion ?? '',
                default: versionInfo.compatibilities?.some((comp) => comp.defaultVersion) ??
                    false,
                compatibleWith: versionInfo.compatibilities?.flatMap((comp) => comp.clusterVersion),
            }))
                .filter((release) => release.version && release.version !== '')
                .filter((release) => {
                if (filter.default) {
                    return release.default && release.default === filter.default;
                }
                return true;
            }),
        };
    }
    getClient({ region, profile }) {
        const cacheKey = `${region ?? 'default'}#${profile ?? 'default'}`;
        if (!(cacheKey in this.clients)) {
            this.clients[cacheKey] = new client_eks_1.EKSClient({
                ...(region && { region }),
                credentials: (0, credential_providers_1.fromNodeProviderChain)(profile ? { profile } : undefined),
            });
        }
        return this.clients[cacheKey];
    }
}
exports.AwsEKSAddonDataSource = AwsEKSAddonDataSource;
tslib_1.__decorate([
    (0, decorator_1.cache)({
        namespace: `datasource-${AwsEKSAddonDataSource.id}`,
        key: ({ packageName }) => `getReleases:${packageName}`,
    })
], AwsEKSAddonDataSource.prototype, "getReleases", null);
//# sourceMappingURL=index.js.map