import type * as bunyan from 'bunyan';
import type { Logger } from './types';
export declare class RenovateLogger implements Logger {
    private readonly bunyanLogger;
    private context;
    private meta;
    readonly logger: Logger;
    readonly once: Logger & {
        reset: () => void;
    };
    constructor(bunyanLogger: bunyan, context: string, meta: Record<string, unknown>);
    trace(p1: string): void;
    trace(p1: Record<string, any>, p2?: string): void;
    debug(p1: string): void;
    debug(p1: Record<string, any>, p2?: string): void;
    info(p1: string): void;
    info(p1: Record<string, any>, p2?: string): void;
    warn(p1: string): void;
    warn(p1: Record<string, any>, p2?: string): void;
    error(p1: string): void;
    error(p1: Record<string, any>, p2?: string): void;
    fatal(p1: string): void;
    fatal(p1: Record<string, any>, p2?: string): void;
    addStream(stream: bunyan.Stream): void;
    childLogger(): RenovateLogger;
    get logContext(): string;
    set logContext(context: string);
    setMeta(obj: Record<string, unknown>): void;
    addMeta(obj: Record<string, unknown>): void;
    removeMeta(fields: string[]): void;
    private logFactory;
    private logOnceFn;
    private log;
}
