import * as bunyan from 'bunyan';
import type { BunyanRecord, Logger } from './types';
import { ProblemStream } from './utils';
export declare function logLevel(): bunyan.LogLevelString;
export declare function createDefaultStreams(stdoutLevel: bunyan.LogLevelString, problems: ProblemStream, logFile: string | undefined): bunyan.Stream[];
export declare const logger: Logger;
export declare function setContext(value: string): void;
export declare function getContext(): any;
export declare function setMeta(obj: Record<string, unknown>): void;
export declare function addMeta(obj: Record<string, unknown>): void;
export declare function removeMeta(fields: string[]): void;
export declare function withMeta<T>(obj: Record<string, unknown>, cb: () => T): T;
export declare function addStream(stream: bunyan.Stream): void;
/**
 * For testing purposes only
 * @param name stream name
 * @param level log level
 * @private
 */
export declare function levels(name: 'stdout' | 'logfile', level: bunyan.LogLevelString): void;
export declare function getProblems(): BunyanRecord[];
export declare function clearProblems(): void;
