"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = errSerializer;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../util/regex");
const utils_1 = tslib_1.__importDefault(require("./utils"));
Error.stackTraceLimit = 20;
function errSerializer(err) {
    const response = (0, utils_1.default)(err);
    // already done by `sanitizeValue` ?
    const redactedFields = ['message', 'stack', 'stdout', 'stderr'];
    for (const field of redactedFields) {
        const val = response[field];
        if (is_1.default.string(val)) {
            response[field] = val.replace((0, regex_1.regEx)(/https:\/\/[^@]*?@/g), 'https://**redacted**@');
        }
    }
    return response;
}
//# sourceMappingURL=err-serializer.js.map