"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTracingEnabled = isTracingEnabled;
exports.isTraceDebuggingEnabled = isTraceDebuggingEnabled;
exports.isTraceSendingEnabled = isTraceSendingEnabled;
exports.massageThrowable = massageThrowable;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const env_1 = require("../util/env");
function isTracingEnabled() {
    return isTraceDebuggingEnabled() || isTraceSendingEnabled();
}
function isTraceDebuggingEnabled() {
    return !!(0, env_1.getEnv)().RENOVATE_TRACING_CONSOLE_EXPORTER;
}
function isTraceSendingEnabled() {
    return !!(0, env_1.getEnv)().OTEL_EXPORTER_OTLP_ENDPOINT;
}
function massageThrowable(e) {
    if (is_1.default.nullOrUndefined(e)) {
        return undefined;
    }
    if (e instanceof Error) {
        return e.message;
    }
    return String(e); // eslint-disable-line @typescript-eslint/no-base-to-string
}
//# sourceMappingURL=utils.js.map