import type { RenovateConfig } from '../config/types';
import type { BranchCache } from '../util/cache/repository/types';
import type { ExtractResult } from '../workers/repository/process/extract-update';
import type { LibYearsWithStatus, Report } from './types';
/**
 * Reset the report
 * Should only be used for testing
 */
export declare function resetReport(): void;
export declare function addBranchStats(config: RenovateConfig, branchesInformation: Partial<BranchCache>[]): void;
export declare function addExtractionStats(config: RenovateConfig, extractResult: ExtractResult): void;
export declare function addLibYears(config: RenovateConfig, libYearsWithDepCount: LibYearsWithStatus): void;
export declare function finalizeReport(): void;
export declare function exportStats(config: RenovateConfig): Promise<void>;
export declare function getReport(): Report;
