import type { CustomManager } from '../../modules/manager/custom/types';
import type { ValidationMessage } from '../types';
export declare function getParentName(parentPath: string | undefined): string;
export declare function validatePlainObject(val: Record<string, unknown>): true | string;
export declare function validateNumber(key: string, val: unknown, allowsNegative: boolean, currentPath?: string, subKey?: string): ValidationMessage[];
/**  An option is a false global if it has the same name as a global only option
 *   but is actually just the field of a non global option or field an children of the non global option
 *   eg. token: it's global option used as the bot's token as well and
 *   also it can be the token used for a platform inside the hostRules configuration
 */
export declare function isFalseGlobal(optionName: string, parentPath?: string): boolean;
export declare function validateRegexManagerFields(customManager: CustomManager, currentPath: string, errors: ValidationMessage[]): void;
export declare function validateJSONataManagerFields(customManager: CustomManager, currentPath: string, errors: ValidationMessage[]): void;
