"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.check = check;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const string_match_1 = require("../../util/string-match");
/**
 * Only if type condition or context condition violated then errors array will be mutated to store metadata
 */
function check({ val: matchers, currentPath, }) {
    const res = [];
    if (is_1.default.array(matchers, is_1.default.string)) {
        if ((matchers.includes('*') || matchers.includes('**')) &&
            matchers.length > 1) {
            res.push({
                topic: 'Configuration Error',
                message: `${currentPath}: Your input contains * or ** along with other patterns. Please remove them, as * or ** matches all patterns.`,
            });
        }
        for (const matcher of matchers) {
            // Validate regex pattern
            // No need to validate if the string is a glob
            // minimatch allows any string as glob
            if ((0, string_match_1.isRegexMatch)(matcher)) {
                if (!(0, string_match_1.getRegexPredicate)(matcher)) {
                    res.push({
                        topic: 'Configuration Error',
                        message: `Failed to parse regex pattern for ${currentPath}: ${matcher}`,
                    });
                }
            }
        }
    }
    else {
        res.push({
            topic: 'Configuration Error',
            message: `${currentPath}: should be an array of strings. You have included ${typeof matchers}.`,
        });
    }
    return res;
}
//# sourceMappingURL=regex-glob-matchers.js.map