"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.check = check;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
/**
 * Only if type condition or context condition violated then errors array will be mutated to store metadata
 */
function check({ resolvedRule, currentPath, baseBranches, }) {
    const warnings = [];
    if (Array.isArray(resolvedRule.matchBaseBranches)) {
        if (!is_1.default.nonEmptyArray(baseBranches)) {
            warnings.push({
                topic: 'Configuration Error',
                message: `${currentPath}: You must configure baseBranches inorder to use them inside matchBaseBranches.`,
            });
        }
    }
    return warnings;
}
//# sourceMappingURL=match-base-branches.js.map