"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPreset = getPreset;
const tslib_1 = require("tslib");
const global_1 = require("../../global");
const gitea = tslib_1.__importStar(require("../gitea"));
const github = tslib_1.__importStar(require("../github"));
const gitlab = tslib_1.__importStar(require("../gitlab"));
const local = tslib_1.__importStar(require("./common"));
const resolvers = {
    azure: local,
    bitbucket: local,
    'bitbucket-server': local,
    codecommit: null,
    gerrit: local,
    gitea,
    github,
    gitlab,
    local: null,
};
function getPreset({ repo, presetName = 'default', presetPath, tag, }) {
    const platform = global_1.GlobalConfig.get('platform');
    if (!platform) {
        throw new Error(`Missing platform config for local preset.`);
    }
    const resolver = resolvers[platform];
    if (!resolver) {
        throw new Error(`The platform you're using (${platform}) does not support local presets.`);
    }
    const endpoint = global_1.GlobalConfig.get('endpoint');
    return resolver.getPresetFromEndpoint(repo, presetName, presetPath, 
    // TODO: fix type #22198
    endpoint, tag);
}
//# sourceMappingURL=index.js.map