"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fetchJSONFile = fetchJSONFile;
exports.getPresetFromEndpoint = getPresetFromEndpoint;
const logger_1 = require("../../../logger");
const platform_1 = require("../../../modules/platform");
const external_host_error_1 = require("../../../types/errors/external-host-error");
const util_1 = require("../util");
async function fetchJSONFile(repo, fileName, _endpoint, tag) {
    let raw;
    try {
        raw = await platform_1.platform.getRawFile(fileName, repo, tag ?? undefined);
    }
    catch (err) {
        if (err instanceof external_host_error_1.ExternalHostError) {
            throw err;
        }
        logger_1.logger.debug(`Preset file ${fileName} not found in ${repo}: ${err.message}}`);
        throw new Error(util_1.PRESET_DEP_NOT_FOUND);
    }
    if (!raw) {
        throw new Error(util_1.PRESET_DEP_NOT_FOUND);
    }
    return (0, util_1.parsePreset)(raw, fileName);
}
function getPresetFromEndpoint(repo, filePreset, presetPath, endpoint, tag) {
    return (0, util_1.fetchPreset)({
        repo,
        filePreset,
        presetPath,
        endpoint,
        tag,
        fetch: fetchJSONFile,
    });
}
//# sourceMappingURL=common.js.map