"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.presets = void 0;
const tslib_1 = require("tslib");
const monorepo_json_1 = tslib_1.__importDefault(require("../../../data/monorepo.json"));
const array_1 = require("../../../util/array");
exports.presets = {};
for (const [name, value] of Object.entries(monorepo_json_1.default.repoGroups)) {
    exports.presets[name] = {
        description: `${name} monorepo`,
        matchSourceUrls: (0, array_1.toArray)(value),
    };
}
for (const [name, value] of Object.entries(monorepo_json_1.default.orgGroups)) {
    exports.presets[name] = {
        description: `${name} monorepo`,
        matchSourceUrls: (0, array_1.toArray)(value).map((url) => `${url}**`),
    };
}
for (const [name, value] of Object.entries(monorepo_json_1.default.patternGroups)) {
    exports.presets[name] = {
        description: `${name} monorepo`,
        matchPackageNames: (0, array_1.toArray)(value),
    };
}
//# sourceMappingURL=monorepos.js.map