"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.presets = void 0;
const tslib_1 = require("tslib");
const abandonments_json_1 = tslib_1.__importDefault(require("../../../data/abandonments.json"));
function loadAbandonmentPresets() {
    const packageRules = [
        {
            matchPackageNames: ['*'],
            abandonmentThreshold: '1 year',
        },
    ];
    for (const [datasource, datasourceAbandonments] of Object.entries(abandonments_json_1.default)) {
        if (datasource === '$schema') {
            continue;
        }
        for (const [packageName, threshold] of Object.entries(datasourceAbandonments)) {
            const abandonmentThreshold = threshold === 'eternal' ? null : threshold;
            packageRules.push({
                matchDatasources: [datasource],
                matchPackageNames: [packageName],
                abandonmentThreshold,
            });
        }
    }
    return {
        recommended: { packageRules },
    };
}
exports.presets = loadAbandonmentPresets();
//# sourceMappingURL=abandonments.js.map