"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SemanticPrefixMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class SemanticPrefixMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'semanticPrefix';
    run(value) {
        if (is_1.default.string(value)) {
            const [text] = value.split(':');
            const [type, scope] = text.split('(');
            this.setSafely('semanticCommitType', type);
            this.setSafely('semanticCommitScope', scope ? scope.split(')')[0] : null);
        }
    }
}
exports.SemanticPrefixMigration = SemanticPrefixMigration;
//# sourceMappingURL=semantic-prefix-migration.js.map