"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduleMigration = void 0;
const tslib_1 = require("tslib");
const later_1 = tslib_1.__importDefault(require("@breejs/later"));
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../../../util/regex");
const abstract_migration_1 = require("../base/abstract-migration");
class ScheduleMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'schedule';
    run(value) {
        if (value) {
            // massage to array first
            let schedules = [];
            if (is_1.default.string(value)) {
                schedules = [value];
            }
            if (is_1.default.array(value)) {
                schedules = [...value];
            }
            // split 'and'
            const schedulesLength = schedules.length;
            for (let i = 0; i < schedulesLength; i += 1) {
                if (schedules[i].includes(' and ') &&
                    schedules[i].includes('before ') &&
                    schedules[i].includes('after ')) {
                    const parsedSchedule = later_1.default.parse.text(
                    // We need to massage short hours first before we can parse it
                    schedules[i].replace((0, regex_1.regEx)(/( \d?\d)((a|p)m)/g), '$1:00$2')).schedules[0];
                    // Only migrate if the after time is greater than before, e.g. "after 10pm and before 5am"
                    if (!parsedSchedule?.t_a || !parsedSchedule.t_b) {
                        continue;
                    }
                    if (parsedSchedule.t_a[0] > parsedSchedule.t_b[0]) {
                        const toSplit = schedules[i];
                        schedules[i] = toSplit
                            .replace((0, regex_1.regEx)(/^(.*?)(after|before) (.*?) and (after|before) (.*?)( |$)(.*)/), // TODO #12071
                        '$1$2 $3 $7')
                            .trim();
                        schedules.push(toSplit
                            .replace((0, regex_1.regEx)(/^(.*?)(after|before) (.*?) and (after|before) (.*?)( |$)(.*)/), // TODO #12071
                        '$1$4 $5 $7')
                            .trim());
                    }
                }
            }
            for (let i = 0; i < schedules.length; i += 1) {
                if (schedules[i].includes('on the last day of the month')) {
                    schedules[i] = schedules[i].replace('on the last day of the month', 'on the first day of the month');
                }
                if (schedules[i].includes('on every weekday')) {
                    schedules[i] = schedules[i].replace('on every weekday', 'every weekday');
                }
                if (schedules[i].endsWith(' every day')) {
                    schedules[i] = schedules[i].replace(' every day', '');
                }
                if ((0, regex_1.regEx)(/every (mon|tues|wednes|thurs|fri|satur|sun)day$/).test(schedules[i]) // TODO #12071
                ) {
                    schedules[i] = schedules[i].replace((0, regex_1.regEx)(/every ([a-z]*day)$/), // TODO #12071
                    'on $1');
                }
                if (schedules[i].endsWith('days')) {
                    schedules[i] = schedules[i].replace('days', 'day');
                }
            }
            if (is_1.default.string(value) && schedules.length === 1) {
                this.rewrite(schedules[0]);
            }
            else {
                this.rewrite(schedules);
            }
        }
    }
}
exports.ScheduleMigration = ScheduleMigration;
//# sourceMappingURL=schedule-migration.js.map