"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackagesMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class PackagesMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'packages';
    run(value) {
        const packageRules = this.get('packageRules');
        let newPackageRules = is_1.default.array(packageRules) ? packageRules : [];
        if (is_1.default.array(value)) {
            newPackageRules = newPackageRules.concat(value);
        }
        this.setHard('packageRules', newPackageRules);
    }
}
exports.PackagesMigration = PackagesMigration;
//# sourceMappingURL=packages-migration.js.map