"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageRulesMigration = exports.renameMap = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
exports.renameMap = {
    matchFiles: 'matchFileNames',
    matchPaths: 'matchFileNames',
    paths: 'matchFileNames',
    languages: 'matchCategories',
    matchLanguages: 'matchCategories',
    baseBranchList: 'matchBaseBranches',
    managers: 'matchManagers',
    datasources: 'matchDatasources',
    depTypeList: 'matchDepTypes',
    packageNames: 'matchPackageNames',
    packagePatterns: 'matchPackagePatterns',
    sourceUrlPrefixes: 'matchSourceUrlPrefixes',
    updateTypes: 'matchUpdateTypes',
};
function renameKeys(packageRule) {
    const newPackageRule = {};
    for (const [key, val] of Object.entries(packageRule)) {
        newPackageRule[exports.renameMap[key] ?? key] = val;
    }
    return newPackageRule;
}
function mergeMatchers(packageRule) {
    const newPackageRule = { ...packageRule };
    for (const [key, val] of Object.entries(packageRule)) {
        const patterns = is_1.default.string(val) ? [val] : val;
        // depName
        if (key === 'matchDepPrefixes') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchDepNames ??= [];
                newPackageRule.matchDepNames.push(...patterns.map((v) => `${v}{/,}**`));
            }
            delete newPackageRule.matchDepPrefixes;
        }
        if (key === 'matchDepPatterns') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchDepNames ??= [];
                newPackageRule.matchDepNames.push(...patterns.map((v) => `/${v}/`));
            }
            delete newPackageRule.matchDepPatterns;
        }
        if (key === 'excludeDepNames') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchDepNames ??= [];
                newPackageRule.matchDepNames.push(...patterns.map((v) => `!${v}`));
            }
            delete newPackageRule.excludeDepNames;
        }
        if (key === 'excludeDepPrefixes') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchDepNames ??= [];
                newPackageRule.matchDepNames.push(...patterns.map((v) => `!${v}{/,}**`));
            }
            delete newPackageRule.excludeDepPrefixes;
        }
        if (key === 'excludeDepPatterns') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchDepNames ??= [];
                newPackageRule.matchDepNames.push(...patterns.map((v) => `!/${v}/`));
            }
            delete newPackageRule.excludeDepPatterns;
        }
        // packageName
        if (key === 'matchPackagePrefixes') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchPackageNames ??= [];
                newPackageRule.matchPackageNames.push(...patterns.map((v) => `${v}{/,}**`));
            }
            delete newPackageRule.matchPackagePrefixes;
        }
        if (key === 'matchPackagePatterns') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchPackageNames ??= [];
                newPackageRule.matchPackageNames.push(...patterns.map((v) => {
                    if (v === '*') {
                        return '*';
                    }
                    return `/${v}/`;
                }));
            }
            delete newPackageRule.matchPackagePatterns;
        }
        if (key === 'excludePackageNames') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchPackageNames ??= [];
                newPackageRule.matchPackageNames.push(...patterns.map((v) => `!${v}`));
            }
            delete newPackageRule.excludePackageNames;
        }
        if (key === 'excludePackagePrefixes') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchPackageNames ??= [];
                newPackageRule.matchPackageNames.push(...patterns.map((v) => `!${v}{/,}**`));
            }
            delete newPackageRule.excludePackagePrefixes;
        }
        if (key === 'excludePackagePatterns') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchPackageNames ??= [];
                newPackageRule.matchPackageNames.push(...patterns.map((v) => `!/${v}/`));
            }
            delete newPackageRule.excludePackagePatterns;
        }
        // sourceUrl
        if (key === 'matchSourceUrlPrefixes') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchSourceUrls ??= [];
                newPackageRule.matchSourceUrls.push(...patterns.map((v) => `${v}{/,}**`));
            }
            delete newPackageRule.matchSourceUrlPrefixes;
        }
        // repository
        if (key === 'excludeRepositories') {
            if (is_1.default.array(patterns, is_1.default.string)) {
                newPackageRule.matchRepositories ??= [];
                newPackageRule.matchRepositories.push(...patterns.map((v) => `!${v}`));
            }
            delete newPackageRule.excludeRepositories;
        }
    }
    return newPackageRule;
}
class PackageRulesMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'packageRules';
    run(value) {
        let packageRules = this.get('packageRules');
        if (is_1.default.nonEmptyArray(packageRules)) {
            packageRules = packageRules.map(renameKeys);
            packageRules = packageRules.map(mergeMatchers);
            this.rewrite(packageRules);
        }
    }
}
exports.PackageRulesMigration = PackageRulesMigration;
//# sourceMappingURL=package-rules-migration.js.map