"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PackageFilesMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class PackageFilesMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'packageFiles';
    run(value) {
        const packageRules = this.get('packageRules') ?? [];
        if (is_1.default.array(value)) {
            const fileList = [];
            for (const packageFile of value) {
                if (is_1.default.nonEmptyObject(packageFile) &&
                    'packageFile' in packageFile &&
                    is_1.default.string(packageFile.packageFile)) {
                    fileList.push(packageFile.packageFile);
                    packageFile.paths = [packageFile.packageFile];
                    delete packageFile.packageFile;
                    if (Object.keys(packageFile).length > 1) {
                        packageRules.push({
                            ...packageFile,
                        });
                    }
                }
                else if (is_1.default.array(packageFile, is_1.default.string)) {
                    fileList.push(...packageFile);
                }
                else if (is_1.default.string(packageFile)) {
                    fileList.push(packageFile);
                }
            }
            if (fileList.length) {
                this.setSafely('includePaths', fileList);
            }
            if (packageRules.length) {
                this.setSafely('packageRules', packageRules);
            }
        }
    }
}
exports.PackageFilesMigration = PackageFilesMigration;
//# sourceMappingURL=package-files-migration.js.map