"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchManagersMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class MatchManagersMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'matchManagers';
    run(value) {
        if (!is_1.default.array(value, is_1.default.string)) {
            return;
        }
        // prefix custom. before custom managers if not present
        const newValue = value.map((manager) => manager === 'regex' ? 'custom.regex' : manager);
        this.rewrite(newValue);
    }
}
exports.MatchManagersMigration = MatchManagersMigration;
//# sourceMappingURL=match-managers-migration.js.map