"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchDatasourcesMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class MatchDatasourcesMigration extends abstract_migration_1.AbstractMigration {
    propertyName = 'matchDatasources';
    run(value) {
        if (Array.isArray(value)) {
            const newValue = value.filter(is_1.default.nonEmptyString).map((datasource) => {
                switch (datasource) {
                    case 'adoptium-java':
                        return 'java-version';
                    case 'dotnet':
                        return 'dotnet-version';
                    case 'node':
                        return 'node-version';
                    default:
                        return datasource;
                }
            });
            this.rewrite(newValue);
        }
    }
}
exports.MatchDatasourcesMigration = MatchDatasourcesMigration;
//# sourceMappingURL=match-datasources-migration.js.map