"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IncludeForksMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class IncludeForksMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'includeForks';
    run(value) {
        if (is_1.default.boolean(value)) {
            this.setSafely('forkProcessing', value ? 'enabled' : 'disabled');
        }
    }
}
exports.IncludeForksMigration = IncludeForksMigration;
//# sourceMappingURL=include-forks-migration.js.map