"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FetchReleaseNotesMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const rename_property_migration_1 = require("../base/rename-property-migration");
class FetchReleaseNotesMigration extends rename_property_migration_1.RenamePropertyMigration {
    constructor(originalConfig, migratedConfig) {
        super('fetchReleaseNotes', 'fetchChangeLogs', originalConfig, migratedConfig);
    }
    run(value) {
        let newValue = value;
        if (is_1.default.boolean(value)) {
            newValue = value ? 'pr' : 'off';
        }
        super.run(newValue);
    }
}
exports.FetchReleaseNotesMigration = FetchReleaseNotesMigration;
//# sourceMappingURL=fetch-release-notes-migration.js.map