"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseBranchMigration = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const abstract_migration_1 = require("../base/abstract-migration");
class BaseBranchMigration extends abstract_migration_1.AbstractMigration {
    deprecated = true;
    propertyName = 'baseBranch';
    run(value) {
        if (is_1.default.array(value)) {
            this.setSafely('baseBranches', value);
        }
        if (is_1.default.string(value)) {
            this.setSafely('baseBranches', [value]);
        }
    }
}
exports.BaseBranchMigration = BaseBranchMigration;
//# sourceMappingURL=base-branch-migration.js.map