"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeChildConfig = void 0;
exports.getManagerConfig = getManagerConfig;
exports.removeGlobalConfig = removeGlobalConfig;
exports.filterConfig = filterConfig;
const tslib_1 = require("tslib");
const logger_1 = require("../logger");
const manager_1 = require("../modules/manager");
const options = tslib_1.__importStar(require("./options"));
const utils_1 = require("./utils");
Object.defineProperty(exports, "mergeChildConfig", { enumerable: true, get: function () { return utils_1.mergeChildConfig; } });
function getManagerConfig(config, manager) {
    let managerConfig = {
        ...config,
        manager,
    };
    const categories = (0, manager_1.get)(manager, 'categories');
    if (categories) {
        managerConfig.categories = categories;
    }
    // TODO: fix types #22198
    managerConfig = (0, utils_1.mergeChildConfig)(managerConfig, config[manager]);
    for (const i of manager_1.allManagersList) {
        delete managerConfig[i];
    }
    return managerConfig;
}
function removeGlobalConfig(config, keepInherited) {
    const outputConfig = { ...config };
    for (const option of options.getOptions()) {
        if (keepInherited && option.inheritConfigSupport) {
            continue;
        }
        if (option.globalOnly) {
            delete outputConfig[option.name];
        }
    }
    return outputConfig;
}
function filterConfig(inputConfig, targetStage) {
    logger_1.logger.trace({ config: inputConfig }, `filterConfig('${targetStage}')`);
    const outputConfig = { ...inputConfig };
    const stages = [
        'global',
        'inherit',
        'repository',
        'package',
        'branch',
        'pr',
    ];
    const targetIndex = stages.indexOf(targetStage);
    for (const option of options.getOptions()) {
        const optionIndex = stages.indexOf(option.stage);
        if (optionIndex !== -1 && optionIndex < targetIndex) {
            delete outputConfig[option.name];
        }
    }
    return outputConfig;
}
//# sourceMappingURL=index.js.map