"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefault = getDefault;
exports.getConfig = getConfig;
const options_1 = require("./options");
// Use functions instead of direct values to avoid introducing global references.
// In particular, we want a new array instance every time we request a default array
// instead of sharing a single instance - mutation of this value could cause serious problems.
// See https://github.com/mend/renovate-on-prem/issues/290 for an example
const defaultValueFactories = {
    boolean: () => true,
    array: () => [],
    string: () => null,
    object: () => null,
    integer: () => null,
};
function getDefault(option) {
    return option.default === undefined
        ? defaultValueFactories[option.type]()
        : option.default;
}
function getConfig() {
    const options = (0, options_1.getOptions)();
    const config = {};
    options.forEach((option) => {
        if (!option.parents || option.parents.includes('.')) {
            config[option.name] = getDefault(option);
        }
    });
    return config;
}
//# sourceMappingURL=defaults.js.map