import { isRegex } from './regex';
export function coerceSymOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || isRegex(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
export function coerceOpOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || isRegex(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
export function coerceCommentOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || isRegex(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
export function coerceNumOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || isRegex(arg1)) {
        return {
            value: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    if (typeof arg1 === 'function') {
        return {
            value: null,
            handler: arg1,
        };
    }
    if (arg1 !== null && typeof arg1 === 'object') {
        return arg1;
    }
    return { value: null, handler: null };
}
export function coerceManyOptions(builder, arg2, arg3) {
    if (typeof arg2 === 'number' && typeof arg3 === 'number') {
        return { builder, min: arg2, max: arg3 };
    }
    return { builder, min: 1, max: null };
}
export function coerceTreeOptions(arg1) {
    if (typeof arg1 === 'string') {
        return { type: arg1 };
    }
    else if (!arg1) {
        return { type: null };
    }
    else {
        return arg1;
    }
}
export function coerceStrOptions(arg1, arg2) {
    if (typeof arg1 === 'string' || isRegex(arg1)) {
        if (arg1 === '') {
            return {
                type: 'str-tree',
                match: [],
                postHandler: arg2
                    ? (ctx, tree) => arg2(ctx, {
                        ...tree.startsWith,
                        type: 'string-value',
                        value: arg1,
                    })
                    : null,
            };
        }
        return {
            type: 'str-content',
            match: arg1,
            handler: arg2 !== null && arg2 !== void 0 ? arg2 : null,
        };
    }
    else if (typeof arg1 === 'function') {
        return {
            type: 'str-content',
            match: null,
            handler: arg1,
        };
    }
    else if (arg1) {
        if (arg1['handler'] ||
            typeof arg1.match === 'string' ||
            isRegex(arg1.match)) {
            return {
                type: 'str-content',
                ...arg1,
            };
        }
        return {
            type: 'str-tree',
            ...arg1,
        };
    }
    return {
        type: 'str-tree',
        match: null,
        preHandler: null,
        postHandler: null,
    };
}
//# sourceMappingURL=options.js.map