import { safeHandler } from '../handler';
import { isRegex } from '../regex';
import { AbstractMatcher } from './abstract-matcher';
export class StrContentMatcher extends AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.content = value !== null && value !== void 0 ? value : null;
        this.handler = safeHandler(handler);
    }
    match(checkpoint) {
        let { cursor, context } = checkpoint;
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'string-value') {
            let isMatched = true;
            if (typeof this.content === 'string') {
                isMatched = this.content === node.value;
            }
            else if (isRegex(this.content)) {
                isMatched = this.content.test(node.value);
            }
            if (isMatched) {
                context = this.handler(context, node);
                cursor = this.moveRight(cursor);
                return { cursor, context };
            }
        }
        return null;
    }
}
export class StrTplMatcher extends AbstractMatcher {
    constructor(config) {
        super();
        this.matcher = config.matcher;
        this.preHandler = safeHandler(config.preHandler);
        this.postHandler = safeHandler(config.postHandler);
    }
    match(checkpoint) {
        var _a;
        const { cursor: tplCursor, context: tplContext } = checkpoint;
        const rootNode = tplCursor.node;
        if ((rootNode === null || rootNode === void 0 ? void 0 : rootNode.type) === 'template-tree') {
            let cursor = checkpoint.cursor.down;
            if (cursor && cursor.node) {
                let context = this.preHandler(tplContext, rootNode);
                cursor = this.matcher.seekNext(cursor);
                const match = this.matcher.match({ context, cursor });
                if (match) {
                    ({ cursor, context } = match);
                    cursor = this.seekNext(cursor);
                    if (((_a = cursor.node) === null || _a === void 0 ? void 0 : _a.type) === '_end') {
                        context = this.postHandler(context, rootNode);
                        cursor = this.moveRight(tplCursor);
                        return { context, cursor };
                    }
                }
            }
        }
        return null;
    }
}
export class StrNodeMatcher extends AbstractMatcher {
    constructor(opts) {
        var _a;
        super();
        this.matchers = (_a = opts.matchers) !== null && _a !== void 0 ? _a : null;
        this.preHandler = safeHandler(opts.preHandler);
        this.postHandler = safeHandler(opts.postHandler);
    }
    match(checkpoint) {
        var _a;
        const rootCursor = this.seekNext(checkpoint.cursor);
        const rootNode = rootCursor.node;
        if ((rootNode === null || rootNode === void 0 ? void 0 : rootNode.type) === 'string-tree') {
            let context = this.preHandler(checkpoint.context, rootNode);
            let cursor = rootCursor;
            if (this.matchers) {
                const tokensCount = cursor.children.length - 2;
                if (tokensCount !== this.matchers.length) {
                    return null;
                }
                if (tokensCount > 0) {
                    cursor = this.moveRight(cursor.down);
                    for (const matcher of this.matchers) {
                        const match = matcher.match({ context, cursor });
                        if (!match) {
                            return null;
                        }
                        ({ cursor, context } = match);
                    }
                }
            }
            context = this.postHandler(context, rootNode);
            cursor = this.moveRight(rootCursor);
            return { context, cursor };
        }
        else if ((rootNode === null || rootNode === void 0 ? void 0 : rootNode.type) === 'string-value' && ((_a = this.matchers) === null || _a === void 0 ? void 0 : _a.length)) {
            const matcher = this.matchers[0];
            return matcher.match({ context: checkpoint.context, cursor: rootCursor });
        }
        return null;
    }
}
//# sourceMappingURL=str-matcher.js.map