import { safeHandler } from '../handler';
import { isRegex } from '../regex';
import { AbstractMatcher } from './abstract-matcher';
export class OpMatcher extends AbstractMatcher {
    constructor({ value, handler }) {
        super();
        this.op = value;
        this.handler = safeHandler(handler);
    }
    match(checkpoint) {
        let context = checkpoint.context;
        let cursor = this.seekNext(checkpoint.cursor);
        const node = cursor.node;
        if ((node === null || node === void 0 ? void 0 : node.type) === 'operator') {
            let isMatched = true;
            if (typeof this.op === 'string') {
                isMatched = this.op === node.value;
            }
            else if (isRegex(this.op)) {
                isMatched = this.op.test(node.value);
            }
            if (isMatched) {
                context = this.handler(context, node);
                cursor = this.moveRight(cursor);
                return { cursor, context };
            }
        }
        return null;
    }
}
//# sourceMappingURL=op-matcher.js.map