import { AbstractMatcher } from './abstract-matcher';
export class AltMatcher extends AbstractMatcher {
    constructor({ matchers }) {
        super();
        this.idx = -1;
        this.checkpoint = null;
        this.alts = matchers;
    }
    match(checkpoint) {
        this.checkpoint = checkpoint;
        this.idx = -1;
        return this.nextMatch();
    }
    nextMatch() {
        if (this.checkpoint) {
            this.idx += 1;
            let matcher = this.alts[this.idx];
            while (matcher) {
                const checkpoint = matcher.match(this.checkpoint);
                if (checkpoint) {
                    return checkpoint;
                }
                this.idx += 1;
                matcher = this.alts[this.idx];
            }
        }
        return null;
    }
}
//# sourceMappingURL=alt-matcher.js.map