const skipByDefault = [
    'whitespace',
    '_start',
    'newline',
    'comment',
];
export class AbstractMatcher {
    canSkip(node) {
        return skipByDefault.includes(node.type);
    }
    seekNext(cursor) {
        let node = cursor.node;
        while (this.canSkip(node)) {
            if (!cursor.right) {
                return cursor;
            }
            cursor = cursor.right;
            node = cursor.node;
        }
        return cursor;
    }
    moveRight(cursor) {
        const result = cursor.right;
        if (result) {
            return result;
        }
        throw new Error('Cursor error: move right');
    }
    nextMatch() {
        return null;
    }
}
//# sourceMappingURL=abstract-matcher.js.map