import type { CommentToken, EndToken, NumberToken, OperatorToken, StartToken, SymbolToken } from '../lexer';
import type { Node, StringTree, Tree, TreeType } from '../parser/types';
import { AltMatcher, ManyMatcher, OpMatcher, SeqMatcher, SymMatcher } from './matchers';
import { BeginMatcher, VoidMatcher } from './matchers/anchor-matcher';
import { CommentMatcher } from './matchers/comment-matcher';
import { NumMatcher } from './matchers/num-matcher';
import { StrContentMatcherHandler, StrNodeMatcher } from './matchers/str-matcher';
import { TreeMatcher } from './matchers/tree-matcher';
import type { CommentMatcherHandler, CommentMatcherOptions, CommentMatcherValue, ManyBuilderOpts, Matcher, NumMatcherHandler, NumMatcherOptions, NumMatcherValue, OpMatcherHandler, OpMatcherOptions, OpMatcherValue, QueryBuilder, StrBuilderOptions, StrTreeBuilderOptions, StrTreeBuilderOptionsBase, SymMatcherHandler, SymMatcherOptions, SymMatcherValue, TreeBuilderOptions } from './types';
declare abstract class TerminalBuilder<Ctx, T extends Node> implements QueryBuilder<Ctx, T> {
    abstract build(): Matcher<Ctx>;
    handler(fn: (context: Ctx, t: T) => Ctx): SeqBuilder<Ctx, T>;
}
declare abstract class AbstractBuilder<Ctx, T extends Node> extends TerminalBuilder<Ctx, T> {
    sym(): SeqBuilder<Ctx, SymbolToken>;
    sym(value: SymMatcherValue): SeqBuilder<Ctx, SymbolToken>;
    sym(handler: SymMatcherHandler<Ctx>): SeqBuilder<Ctx, SymbolToken>;
    sym(value: SymMatcherValue, handler: SymMatcherHandler<Ctx>): SeqBuilder<Ctx, SymbolToken>;
    sym(opts: SymMatcherOptions<Ctx>): SeqBuilder<Ctx, SymbolToken>;
    op(): SeqBuilder<Ctx, OperatorToken>;
    op(value: OpMatcherValue): SeqBuilder<Ctx, OperatorToken>;
    op(handler: OpMatcherHandler<Ctx>): SeqBuilder<Ctx, OperatorToken>;
    op(value: OpMatcherValue, handler: OpMatcherHandler<Ctx>): SeqBuilder<Ctx, OperatorToken>;
    op(opts: OpMatcherOptions<Ctx>): SeqBuilder<Ctx, OperatorToken>;
    comment(): SeqBuilder<Ctx, CommentToken>;
    comment(value: CommentMatcherValue): SeqBuilder<Ctx, CommentToken>;
    comment(handler: CommentMatcherHandler<Ctx>): SeqBuilder<Ctx, CommentToken>;
    comment(value: CommentMatcherValue, handler: CommentMatcherHandler<Ctx>): SeqBuilder<Ctx, CommentToken>;
    comment(opts: CommentMatcherOptions<Ctx>): SeqBuilder<Ctx, CommentToken>;
    num(): SeqBuilder<Ctx, NumberToken>;
    num(value: NumMatcherValue): SeqBuilder<Ctx, NumberToken>;
    num(handler: NumMatcherHandler<Ctx>): SeqBuilder<Ctx, NumberToken>;
    num(value: NumMatcherValue, handler: NumMatcherHandler<Ctx>): SeqBuilder<Ctx, NumberToken>;
    num(opts: NumMatcherOptions<Ctx>): SeqBuilder<Ctx, NumberToken>;
    many(builder: QueryBuilder<Ctx, Node>): SeqBuilder<Ctx, Node>;
    many(builder: QueryBuilder<Ctx, Node>, min: number, max: number): SeqBuilder<Ctx, Node>;
    opt(innerBuilder: QueryBuilder<Ctx, Node>): SeqBuilder<Ctx, Node>;
    alt(...alts: QueryBuilder<Ctx, Node>[]): SeqBuilder<Ctx, Node>;
    tree(): SeqBuilder<Ctx, Tree>;
    tree(type: TreeType): SeqBuilder<Ctx, Tree>;
    tree(opts: TreeBuilderOptions<Ctx>): SeqBuilder<Ctx, Tree>;
    str(): SeqBuilder<Ctx, StringTree>;
    str(handler: StrContentMatcherHandler<Ctx>): SeqBuilder<Ctx, StringTree>;
    str(exact: string, handler?: StrContentMatcherHandler<Ctx>): SeqBuilder<Ctx, StringTree>;
    str(pattern: RegExp, handler?: StrContentMatcherHandler<Ctx>): SeqBuilder<Ctx, StringTree>;
    str(opts: StrTreeBuilderOptions<Ctx>): SeqBuilder<Ctx, StringTree>;
    end(): EndBuilder<Ctx, T>;
    join<U extends Node>(other: QueryBuilder<Ctx, U>): SeqBuilder<Ctx, U>;
}
export declare class BeginBuilder<Ctx, T extends Node> extends AbstractBuilder<Ctx, T> {
    build(): BeginMatcher<Ctx>;
}
export declare class EndBuilder<Ctx, T extends Node> extends TerminalBuilder<Ctx, EndToken> {
    private readonly builder;
    constructor(builder: QueryBuilder<Ctx, T>);
    build(): SeqMatcher<Ctx>;
}
export declare function begin<Ctx>(): BeginBuilder<Ctx, StartToken>;
export declare class VoidBuilder<Ctx, T extends Node> extends AbstractBuilder<Ctx, T> {
    private readonly fn;
    constructor(fn: (context: Ctx, t: T) => Ctx);
    build(): VoidMatcher<Ctx, T>;
}
export declare function handler<Ctx>(fn: (context: Ctx, t: Node) => Ctx): VoidBuilder<Ctx, Node>;
export declare class SeqBuilder<Ctx, T extends Node> extends AbstractBuilder<Ctx, T> {
    private readonly builders;
    constructor(prev: QueryBuilder<Ctx, Node>, next: QueryBuilder<Ctx, T>);
    build(): SeqMatcher<Ctx>;
}
export declare function join<Ctx>(first: QueryBuilder<Ctx, Node>, second: QueryBuilder<Ctx, Node>, ...others: QueryBuilder<Ctx, Node>[]): SeqBuilder<Ctx, Node>;
export declare class SymBuilder<Ctx> extends AbstractBuilder<Ctx, SymbolToken> {
    private opts;
    constructor(opts: SymMatcherOptions<Ctx>);
    build(): SymMatcher<Ctx>;
}
export declare function sym<Ctx>(): SymBuilder<Ctx>;
export declare function sym<Ctx>(value: SymMatcherValue): SymBuilder<Ctx>;
export declare function sym<Ctx>(handler: SymMatcherHandler<Ctx>): SymBuilder<Ctx>;
export declare function sym<Ctx>(value: SymMatcherValue, handler: SymMatcherHandler<Ctx>): SymBuilder<Ctx>;
export declare function sym<Ctx>(opts: SymMatcherOptions<Ctx>): SymBuilder<Ctx>;
export declare class OpBuilder<Ctx> extends AbstractBuilder<Ctx, OperatorToken> {
    private opts;
    constructor(opts: OpMatcherOptions<Ctx>);
    build(): OpMatcher<Ctx>;
}
export declare function op<Ctx>(): OpBuilder<Ctx>;
export declare function op<Ctx>(value: OpMatcherValue): OpBuilder<Ctx>;
export declare function op<Ctx>(handler: OpMatcherHandler<Ctx>): OpBuilder<Ctx>;
export declare function op<Ctx>(value: OpMatcherValue, handler: OpMatcherHandler<Ctx>): OpBuilder<Ctx>;
export declare function op<Ctx>(opts: OpMatcherOptions<Ctx>): OpBuilder<Ctx>;
export declare class CommentBuilder<Ctx> extends AbstractBuilder<Ctx, CommentToken> {
    private opts;
    constructor(opts: CommentMatcherOptions<Ctx>);
    build(): CommentMatcher<Ctx>;
}
export declare function comment<Ctx>(): CommentBuilder<Ctx>;
export declare function comment<Ctx>(value: CommentMatcherValue): CommentBuilder<Ctx>;
export declare function comment<Ctx>(handler: CommentMatcherHandler<Ctx>): CommentBuilder<Ctx>;
export declare function comment<Ctx>(value: CommentMatcherValue, handler: CommentMatcherHandler<Ctx>): CommentBuilder<Ctx>;
export declare function comment<Ctx>(opts: CommentMatcherOptions<Ctx>): CommentBuilder<Ctx>;
export declare class NumBuilder<Ctx> extends AbstractBuilder<Ctx, NumberToken> {
    private opts;
    constructor(opts: NumMatcherOptions<Ctx>);
    build(): NumMatcher<Ctx>;
}
export declare function num<Ctx>(): NumBuilder<Ctx>;
export declare function num<Ctx>(value: NumMatcherValue): NumBuilder<Ctx>;
export declare function num<Ctx>(handler: NumMatcherHandler<Ctx>): NumBuilder<Ctx>;
export declare function num<Ctx>(value: NumMatcherValue, handler: NumMatcherHandler<Ctx>): NumBuilder<Ctx>;
export declare function num<Ctx>(opts: NumMatcherOptions<Ctx>): NumBuilder<Ctx>;
export declare class ManyBuilder<Ctx> extends AbstractBuilder<Ctx, Node> {
    private opts;
    constructor(opts: ManyBuilderOpts<Ctx>);
    build(): ManyMatcher<Ctx>;
}
export declare function many<Ctx>(builder: QueryBuilder<Ctx, Node>): ManyBuilder<Ctx>;
export declare function many<Ctx>(builder: QueryBuilder<Ctx, Node>, min: number, max: number): ManyBuilder<Ctx>;
export declare function opt<Ctx>(builder: QueryBuilder<Ctx, Node>): ManyBuilder<Ctx>;
export declare class AltBuilder<Ctx> extends AbstractBuilder<Ctx, Node> {
    private builders;
    constructor(builders: QueryBuilder<Ctx, Node>[]);
    build(): AltMatcher<Ctx>;
}
export declare function alt<Ctx>(...builders: QueryBuilder<Ctx, Node>[]): AltBuilder<Ctx>;
export declare class TreeBuilder<Ctx> extends AbstractBuilder<Ctx, Tree> {
    private opts;
    constructor(opts: TreeBuilderOptions<Ctx>);
    build(): TreeMatcher<Ctx>;
}
export declare function tree<Ctx>(): TreeBuilder<Ctx>;
export declare function tree<Ctx>(type: TreeType): TreeBuilder<Ctx>;
export declare function tree<Ctx>(opts: TreeBuilderOptions<Ctx>): TreeBuilder<Ctx>;
export declare class StrBuilder<Ctx> extends AbstractBuilder<Ctx, StringTree> {
    private opts;
    constructor(opts: StrBuilderOptions<Ctx>);
    build(): StrNodeMatcher<Ctx>;
}
export declare function str<Ctx>(): StrBuilder<Ctx>;
export declare function str<Ctx>(handler: StrContentMatcherHandler<Ctx>): StrBuilder<Ctx>;
export declare function str<Ctx>(exact: string, handler?: StrContentMatcherHandler<Ctx>): StrBuilder<Ctx>;
export declare function str<Ctx>(pattern: RegExp, handler?: StrContentMatcherHandler<Ctx>): StrBuilder<Ctx>;
export declare function str<Ctx>(opts: StrTreeBuilderOptionsBase<Ctx>): StrBuilder<Ctx>;
export declare function buildRoot<Ctx>(builder: QueryBuilder<Ctx, Node>): Matcher<Ctx>;
export {};
//# sourceMappingURL=builder.d.ts.map