import { clone } from '../util/clone';
import { escape } from '../util/regex';
import { getCounterpartBracketKey, isBracketKey, isRightKey } from './bracket';
import { fallbackRule } from './rules';
function copyStateDefinition(state) {
    const result = clone(state);
    Object.entries(result).forEach(([key, val]) => {
        result[key] = clone(val);
    });
    return result;
}
function exprTplStatesMap($, { tplEndToken, tplEnd }) {
    const rootState = {};
    const tplState = copyStateDefinition($);
    for (const [bracketKey, bracketRule] of Object.entries(tplState)) {
        if (bracketRule.t === 'string' &&
            isBracketKey(bracketKey) &&
            isRightKey(bracketKey) &&
            (bracketRule.match.startsWith(tplEnd) ||
                tplEnd.startsWith(bracketRule.match))) {
            const counterpartKey = getCounterpartBracketKey(bracketKey);
            if (!counterpartKey) {
                throw new Error('String template definition conflicts with brackets');
            }
            const counterpartRule = tplState[counterpartKey];
            if (!counterpartRule || counterpartRule.t !== 'string') {
                throw new Error('String template definition conflicts with brackets');
            }
            delete tplState[bracketKey];
            counterpartRule.push = '$';
            rootState[counterpartKey] = clone(counterpartRule);
            rootState[bracketKey] = { ...bracketRule, pop: 1 };
        }
    }
    const tplEndRule = {
        t: 'string',
        type: tplEndToken,
        match: tplEnd,
        chunk: tplEnd,
        pop: 1,
    };
    tplState[tplEndToken] = tplEndRule;
    return { $: rootState, tplState };
}
export function configStrings(states, opts) {
    if (!opts.length) {
        return states;
    }
    const $ = copyStateDefinition(states.$);
    const strStates = {};
    const exprTplPreStates = [];
    const tplStates = {};
    opts.forEach((strOpt, strIdx) => {
        const { startsWith: strStart, endsWith: strEnd = strStart, templates: tplOpts, } = strOpt;
        const strToken = `str$${strIdx}`;
        const strStartToken = `${strToken}$start`;
        const strEndToken = `${strToken}$end`;
        const strValueToken = `${strToken}$value`;
        const strStateName = `${strToken}$state`;
        const strState = {
            [strEndToken]: {
                t: 'string',
                type: strEndToken,
                match: strEnd,
                chunk: strEnd,
                pop: 1,
            },
            [strValueToken]: { ...fallbackRule, type: strValueToken },
        };
        tplOpts === null || tplOpts === void 0 ? void 0 : tplOpts.forEach((tplOpt, tplIdx) => {
            var _a;
            const { startsWith: tplStart } = tplOpt;
            if (tplOpt.type === 'expr') {
                const tplToken = `${strToken}$tpl$${tplIdx}`;
                const tplStartToken = `${tplToken}$start`;
                const tplEndToken = `${tplToken}$end`;
                const tplStateName = `${tplToken}$state`;
                strState[tplStartToken] = {
                    t: 'string',
                    type: tplStartToken,
                    match: tplStart,
                    chunk: tplStart,
                    push: tplStateName,
                };
                const { endsWith: tplEnd } = tplOpt;
                exprTplPreStates.push({ tplStateName, tplEndToken, tplEnd });
            }
            if (tplOpt.type === 'var') {
                const tplToken = `${strToken}$tpl$${tplIdx}`;
                const tplStartToken = `${tplToken}$start`;
                const tplTokenName = `${tplToken}$token`;
                const { operators = [], symbols } = tplOpt;
                let symRegex = symbols;
                if (!symRegex && ((_a = $.symbol) === null || _a === void 0 ? void 0 : _a.t) === 'regex') {
                    symRegex = $.symbol.match;
                }
                if (!symRegex) {
                    throw new Error(`String definition isn't found for template definition`);
                }
                const start = escape(tplStart);
                const symSource = symRegex.source;
                let varTplSource = `${start}${symSource}`;
                const opRules = {};
                if (operators.length) {
                    const opSource = `(?:${operators.map(escape).join('|')})`;
                    varTplSource += `(?:${opSource}${symSource})*`;
                    operators.forEach((match, idx) => {
                        const type = `op$${idx}`;
                        opRules[type] = {
                            t: 'string',
                            type,
                            match,
                            chunk: match,
                        };
                    });
                }
                const match = new RegExp(varTplSource);
                strState[tplTokenName] = {
                    t: 'regex',
                    type: tplTokenName,
                    match,
                    chunk: tplStart,
                };
                const tplStartRule = {
                    t: 'string',
                    type: tplStartToken,
                    match: tplStart,
                    chunk: tplStart,
                };
                const symbolRule = {
                    t: 'regex',
                    type: 'symbol',
                    match: symRegex,
                    chunk: null,
                };
                tplStates[tplTokenName] = {
                    [tplStartToken]: tplStartRule,
                    symbol: symbolRule,
                    ...opRules,
                };
            }
        });
        strStates[strStateName] = strState;
        $[strStartToken] = {
            t: 'string',
            type: strStartToken,
            match: strStart,
            chunk: strStart,
            push: strStateName,
        };
    });
    for (const exprTplStateInput of exprTplPreStates) {
        const { tplStateName } = exprTplStateInput;
        const exprTplStates = exprTplStatesMap($, exprTplStateInput);
        Object.assign($, exprTplStates.$);
        tplStates[tplStateName] = exprTplStates.tplState;
    }
    return { $, ...strStates, ...tplStates };
}
//# sourceMappingURL=string.js.map