export function configOperators(states, operators) {
    const operatorRules = {};
    operators.map((op, idx) => {
        const tokenName = `op$${idx}`;
        const tokenRule = {
            t: 'string',
            type: tokenName,
            match: op,
            chunk: op,
        };
        operatorRules[tokenName] = tokenRule;
    });
    return {
        ...states,
        $: {
            ...states.$,
            ...operatorRules,
        },
    };
}
//# sourceMappingURL=operator.js.map