import type { Cursor } from '../../parser/types';
import type { Checkpoint, Matcher, TreeMatcherHandler, TreeMatcherType, TreeOptionsBase } from '../types';
import { AbstractMatcher } from './abstract-matcher';
interface TreeMatcherOptions<Ctx> extends TreeOptionsBase<Ctx> {
    matcher: Matcher<Ctx> | null;
}
export declare class TreeMatcher<Ctx> extends AbstractMatcher<Ctx> {
    readonly type: TreeMatcherType | null;
    readonly startsWithValue: string | null;
    readonly endsWithValue: string | null;
    readonly matcher: Matcher<Ctx> | null;
    readonly maxDepth: number;
    readonly maxMatches: number;
    readonly preHandler: TreeMatcherHandler<Ctx>;
    readonly postHandler: TreeMatcherHandler<Ctx>;
    private walkDepth;
    private matchCount;
    constructor(config: TreeMatcherOptions<Ctx>);
    walkToNextSignificantNode(cursor: Cursor): Cursor | undefined;
    walkToNextMatch(context: Ctx, cursor: Cursor | undefined): Checkpoint<Ctx> | undefined;
    match(checkpoint: Checkpoint<Ctx>): Checkpoint<Ctx> | null;
}
export {};
//# sourceMappingURL=tree-matcher.d.ts.map