"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManyMatcher = void 0;
const abstract_matcher_1 = require("./abstract-matcher");
class ManyMatcher extends abstract_matcher_1.AbstractMatcher {
    constructor({ matcher, min, max }) {
        super();
        this.idx = 0;
        this.matches = [];
        if (min < 0) {
            throw new Error(`Invalid minimal bound: ${min}`);
        }
        if (max !== null && min > max) {
            throw new Error(`Invalid boundaries: ${min} > ${max}`);
        }
        this.manyOf = matcher;
        this.min = min;
        this.max = max;
    }
    nextRound(checkpoints) {
        const results = [];
        for (const oldCheckpoint of checkpoints) {
            const newCheckpoint = this.manyOf.match(oldCheckpoint);
            if (!newCheckpoint) {
                continue;
            }
            const matchResults = [newCheckpoint];
            let nextResult = this.manyOf.nextMatch();
            while (nextResult) {
                matchResults.push(nextResult);
                nextResult = this.manyOf.nextMatch();
            }
            results.unshift(...matchResults);
        }
        return results;
    }
    match(checkpoint) {
        var _a;
        this.idx = 0;
        let roundResults = [checkpoint];
        this.matches = this.min === 0 ? [checkpoint] : [];
        let round = 1;
        while (this.max !== null ? round <= this.max : true) {
            roundResults = this.nextRound(roundResults);
            if (roundResults.length) {
                this.matches.unshift(...roundResults);
                round += 1;
            }
            else {
                break;
            }
        }
        return (_a = this.matches[this.idx]) !== null && _a !== void 0 ? _a : null;
    }
    nextMatch() {
        var _a;
        this.idx += 1;
        return (_a = this.matches[this.idx]) !== null && _a !== void 0 ? _a : null;
    }
}
exports.ManyMatcher = ManyMatcher;
//# sourceMappingURL=many-matcher.js.map