"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AltMatcher = void 0;
const abstract_matcher_1 = require("./abstract-matcher");
class AltMatcher extends abstract_matcher_1.AbstractMatcher {
    constructor({ matchers }) {
        super();
        this.idx = -1;
        this.checkpoint = null;
        this.alts = matchers;
    }
    match(checkpoint) {
        this.checkpoint = checkpoint;
        this.idx = -1;
        return this.nextMatch();
    }
    nextMatch() {
        if (this.checkpoint) {
            this.idx += 1;
            let matcher = this.alts[this.idx];
            while (matcher) {
                const checkpoint = matcher.match(this.checkpoint);
                if (checkpoint) {
                    return checkpoint;
                }
                this.idx += 1;
                matcher = this.alts[this.idx];
            }
        }
        return null;
    }
}
exports.AltMatcher = AltMatcher;
//# sourceMappingURL=alt-matcher.js.map