"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLang = exports.Language = void 0;
const lexer_1 = require("../lexer");
const parser_1 = require("../parser");
const query_1 = require("../query");
const clone_1 = require("../util/clone");
const groovy_1 = require("./groovy");
const python_1 = require("./python");
const scala_1 = require("./scala");
const starlark_1 = require("./starlark");
__exportStar(require("./types"), exports);
class Language {
    constructor(config) {
        this.config = config;
        this.lexer = (0, lexer_1.createLexer)(config.lexer);
    }
    parse(input) {
        this.lexer.reset(input);
        const root = (0, parser_1.createTree)(this.lexer, this.config.parser);
        return (0, parser_1.createCursor)(root);
    }
    query(input, q, context) {
        const matcher = (0, query_1.buildRoot)(q);
        const cursor = typeof input === 'string' ? this.parse(input) : input;
        const checkpoint = matcher.match({ cursor, context });
        const result = checkpoint === null || checkpoint === void 0 ? void 0 : checkpoint.context;
        return result ? (0, clone_1.clone)(result) : null;
    }
}
exports.Language = Language;
const languagePresets = {
    groovy: groovy_1.lang,
    python: python_1.lang,
    scala: scala_1.lang,
    starlark: starlark_1.lang,
};
function createLang(arg1) {
    const config = typeof arg1 === 'string' ? languagePresets[arg1] : arg1;
    return new Language(config);
}
exports.createLang = createLang;
//# sourceMappingURL=index.js.map