"use strict";
exports.__esModule = true;
exports.isShorterThan = void 0;
var curry2_1 = require("./lib/curry2");
var is_indexed_list_1 = require("./lib/is-indexed-list");
/**
 * Asserts that a value is a `String` or `Array` whose length is less than that
 * of the other provided.
 * @param other ['i', 'have', 4, 'items']
 * @param value ['i have one item']
 * @matcherName toBeShorterThan
 * @memberMatcherName toHaveShorterThan
 * @matcherMessage expected ${value} to be a string or array whose length is
 * less than that of ${other}
 * @matcherNotMessage expected ${value} not to be a string or array whose length
 * is less than that of ${other}
 */
exports.isShorterThan = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_indexed_list_1.isIndexedList)(value) && (0, is_indexed_list_1.isIndexedList)(other) && value.length < other.length;
});
