"use strict";
exports.__esModule = true;
exports.isSameLengthAs = void 0;
var curry2_1 = require("./lib/curry2");
var is_indexed_list_1 = require("./lib/is-indexed-list");
/**
 * Asserts that a value is a `String` or `Array` whose length is the same as
 * that of the other provided.
 * @param other ['i have', '2 items']
 * @param value ['i also have', '2 items']
 * @matcherName toBeSameLengthAs
 * @memberMatcherName toHaveSameLengthAs
 * @matcherMessage expected ${value} to be a string or array whose length is the
 * same as that of ${other}
 * @matcherNotMessage expected ${value} not to be a string or array whose length
 * is the same as that of ${other}
 */
exports.isSameLengthAs = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_indexed_list_1.isIndexedList)(value) && (0, is_indexed_list_1.isIndexedList)(other) && value.length === other.length;
});
