"use strict";
exports.__esModule = true;
exports.isPositiveNumber = void 0;
var is_number_1 = require("./is-number");
/**
 * Asserts that a value is a `Number` greater than 0.
 * @param value 5
 * @matcherName toBePositiveNumber
 * @memberMatcherName toHavePositiveNumber
 * @matcherMessage expected ${value} to be a positive number
 * @matcherNotMessage expected ${value} not to be a positive number
 */
var isPositiveNumber = function (value) { return (0, is_number_1.isNumber)(value) && value > 0; };
exports.isPositiveNumber = isPositiveNumber;
