"use strict";
exports.__esModule = true;
exports.isNil = void 0;
var is_null_1 = require("./is-null");
var is_undefined_1 = require("./is-undefined");
/**
 * Asserts that a value is `null` or `undefined`
 * @param value undefined
 * @matcherName toBeNil
 * @memberMatcherName toHaveNil
 * @matcherMessage expected ${value} to be null or undefined
 * @matcherNotMessage expected ${value} not to be null or undefined
 */
var isNil = function (value) {
    return (0, is_null_1.isNull)(value) || (0, is_undefined_1.isUndefined)(value);
};
exports.isNil = isNil;
