/**
 * Asserts that a value is a String which conforms to common use-cases of the
 * ISO 8601 standard representation of dates and times.
 * @param value '1999-12-31T23:59:59'
 * @matcherName toBeIso8601
 * @memberMatcherName toHaveIso8601
 * @matcherMessage expected ${value} to be a valid ISO 8601 date string
 * @matcherNotMessage expected ${value} not to be a valid ISO 8601 date string
 */
export declare const isIso8601: (value: unknown) => value is string;
