"use strict";
exports.__esModule = true;
exports.isGreaterThanOrEqualTo = void 0;
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is greater than or equal to ${other}.
 * @param other 5
 * @param value 10
 * @matcherName toBeGreaterThanOrEqualTo
 * @memberMatcherName toHaveGreaterThanOrEqualTo
 * @matcherMessage expected ${value} to be greater than or equal to ${other}
 * @matcherNotMessage expected ${value} not to be greater than or equal to
 * ${other}
 */
exports.isGreaterThanOrEqualTo = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_number_1.isNumber)(value) && (0, is_number_1.isNumber)(other) && value >= other;
});
