"use strict";
exports.__esModule = true;
exports.isDateOnOrBefore = void 0;
var is_date_1 = require("./is-date");
var is_less_than_or_equal_to_1 = require("./is-less-than-or-equal-to");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is an instance of `Date` occurring on or before the exact
 * date and time of another.
 * @param other new Date('2019-12-31')
 * @param value new Date('2019-12-15')
 * @matcherName toBeDateOnOrBefore
 * @memberMatcherName toHaveDateOnOrBefore
 * @matcherMessage expected ${value} to be an instance of Date occurring on or
 * before ${other}
 * @matcherNotMessage expected ${value} not to be an instance of Date occurring
 * on or before ${other}
 */
exports.isDateOnOrBefore = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_date_1.isDate)(value) && (0, is_date_1.isDate)(other) && (0, is_less_than_or_equal_to_1.isLessThanOrEqualTo)(other.getTime(), value.getTime());
});
