"use strict";
exports.__esModule = true;
exports.isDateOnOrAfter = void 0;
var is_date_1 = require("./is-date");
var is_greater_than_or_equal_to_1 = require("./is-greater-than-or-equal-to");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is an instance of `Date` occurring on or after the exact
 * date and time of another.
 * @param other new Date('2019-12-15')
 * @param value new Date('2019-12-31')
 * @matcherName toBeDateOnOrAfter
 * @memberMatcherName toHaveDateOnOrAfter
 * @matcherMessage expected ${value} to be an instance of Date occurring on or
 * after ${other}
 * @matcherNotMessage expected ${value} not to be an instance of Date occurring
 * on or after ${other}
 */
exports.isDateOnOrAfter = (0, curry2_1.curry2)(function (other, value) {
    return (0, is_date_1.isDate)(value) && (0, is_date_1.isDate)(other) && (0, is_greater_than_or_equal_to_1.isGreaterThanOrEqualTo)(other.getTime(), value.getTime());
});
