"use strict";
exports.__esModule = true;
exports.isDateInYear = void 0;
var is_date_1 = require("./is-date");
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is an instance of `Date` occurring in the given year.
 * @param year 2021
 * @param value new Date('2021-08-29')
 * @matcherName toBeDateInYear
 * @memberMatcherName toHaveDateInYear
 * @matcherMessage expected ${value} to be an instance of Date occurring in the
 * year ${year}
 * @matcherNotMessage expected ${value} not to be an instance of Date occurring
 * in the year ${year}
 */
exports.isDateInYear = (0, curry2_1.curry2)(function (year, value) {
    return (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(year) && value.getFullYear() === year;
});
