"use strict";
exports.__esModule = true;
exports.isDateInMonth = void 0;
var is_date_1 = require("./is-date");
var is_number_1 = require("./is-number");
var curry2_1 = require("./lib/curry2");
/**
 * Asserts that a value is an instance of `Date` occurring on the given month of
 * the year, where January is `0` and December is `11`.
 * @param index 7
 * @param value new Date('2021-08-29')
 * @matcherName toBeDateInMonth
 * @memberMatcherName toHaveDateInMonth
 * @matcherMessage expected ${value} to be an instance of Date occurring on the
 * month of the year with index ${index}
 * @matcherNotMessage expected ${value} not to be an instance of Date occurring
 * on the month of the year with index ${index}
 */
exports.isDateInMonth = (0, curry2_1.curry2)(function (index, value) {
    return (0, is_date_1.isDate)(value) && (0, is_number_1.isNumber)(index) && value.getMonth() === index;
});
