"use strict";
exports.__esModule = true;
exports.isCalculable = void 0;
/**
 * Assert value can be used in Mathemetic calculations despite not being a
 * `Number`, for example `'1' * '2' === 2` whereas `'wut?' * 2 === NaN`.
 * @param value '100'
 * @matcherName toBeCalculable
 * @memberMatcherName toHaveCalculable
 * @matcherMessage expected ${value} to be coercible for use in mathemetical
 * operations
 * @matcherNotMessage expected ${value} not to be coercible for use in
 * mathemetical operations
 */
var isCalculable = function (value) { return !isNaN(value * 2); };
exports.isCalculable = isCalculable;
