"use strict";
exports.__esModule = true;
exports.isAsyncFunction = void 0;
var has_type_1 = require("./lib/has-type");
/**
 * Asserts that a value is a function using `async` and `await` syntax.
 * @param value async () => { await fetch('...') }
 * @matcherName toBeAsyncFunction
 * @memberMatcherName toHaveAsyncFunction
 * @matcherMessage expected ${value} to be a `Function` using async/await syntax
 * @matcherNotMessage expected ${value} not to be a function using async/await
 * syntax
 */
exports.isAsyncFunction = (0, has_type_1.hasType)('AsyncFunction');
